<?php
/**
 * Cando functions and definitions
 */

load_theme_textdomain( 'zardkooh', trailingslashit(get_template_directory()).'languages' );

add_action( 'after_setup_theme', 'zardkooh_setup' );
function zardkooh_setup() {
	
	require_once ( get_template_directory() . '/include/admin/cando-config.php');

	global $zardkooh_options;

	$zardkooh_options = get_option( 'zardkooh_options' );
	
	require_once ( get_template_directory() . '/include/cando-init.php');

	load_theme_textdomain( 'zardkooh' );

	add_theme_support( 'automatic-feed-links' );

	add_theme_support( 'title-tag' );

	add_theme_support( 'post-thumbnails' );
	
	add_image_size( 'blog-thumb', 58 );

	register_nav_menus( array (
		'main'		=> __( 'Main Menu', 'zardkooh' ),
        'main_mob'	=> __( 'Mobile Main Menu', 'zardkooh' ),
		'top'		=> __( 'Top Menu', 'zardkooh' ),
	));	

	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
		'audio',
	) );

	add_theme_support( 'customize-selective-refresh-widgets' );
	
	add_theme_support( 'woocommerce' );

}

add_action( 'wp_head', 'zardkooh_javascript_detection', 0 );
function zardkooh_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}

add_action( 'wp_head', 'zardkooh_pingback_header' );
function zardkooh_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">' . "\n", get_bloginfo( 'pingback_url' ) );
	}
}

function rm_query_string( $src ){   
    $parts = explode( '?ver', $src );
    return $parts[0];
}
if ( !is_admin() ) {
    add_filter( 'script_loader_src', 'rm_query_string', 15, 1 );
    add_filter( 'style_loader_src', 'rm_query_string', 15, 1 );
}

require_once dirname( __FILE__ ) . '/include/plugins/plugin-activation.php';

add_action( 'tgmpa_register', 'zardkooh_require_plugins' );

function zardkooh_require_plugins() {

    $plugins = array(
        array(
            'name'      => 'Redux Framework',
            'slug'      => 'redux-framework',
            'required'  => true,
        ),
        array(
            'name'      => 'Woocommerce',
            'slug'      => 'woocommerce',
            'required'  => true,
        ),
        array(
            'name'      => 'Persian Woocommerce',
            'slug'      => 'persian-woocommerce',
            'required'  => true,
        ),
        array(
            'name'      => 'Menu Image',
            'slug'      => 'menu-image',
            'required'  => true,
        ),
        array(
            'name'      => 'Elementor',
            'slug'      => 'elementor',
            'required'  => true,
        ),
        array(
            'name'      => 'Contact Form 7',
            'slug'      => 'contact-form-7',
            'required'  => false,
        ),
        array(
            'name'      => 'Variation Swatches for WooCommerce',
            'slug'      => 'woo-variation-swatches',
            'required'  => true,
        ),
        array(
            'name'               => 'AJAX Search for WooCommerce',
            'slug'               => 'ajax-search-for-woocommerce',
            'source'             => get_stylesheet_directory() . '/include/plugins/ajax-search-for-woocommerce.zip',
            'required'           => true,
            'version'            => '1.8.0',
        ),
        array(
            'name'               => 'QR Code Woocommerce',
            'slug'               => 'qr-code-woocommerce',
            'source'             => get_stylesheet_directory() . '/include/plugins/qr-code-woocommerce.zip',
            'required'           => true,
            'version'            => '0.4',
        ),
		array(
            'name'               => 'WP Rating System',
            'slug'               => 'rate-my-post',
            'source'             => get_stylesheet_directory() . '/include/plugins/rate-my-post.zip',
            'required'           => true,
            'version'            => '3.3.1',
        ),
        array(
            'name'               => 'YITH WooCommerce Brands Add On',
            'slug'               => 'yith-woocommerce-brands-add-on',
            'source'             => get_stylesheet_directory() . '/include/plugins/yith-woocommerce-brands-add-on.zip',
            'required'           => false,
            'version'            => '1.3.19',
        ),
        array(
            'name'               => 'YITH WooCommerce Ajax Product Filter Premium',
            'slug'               => 'yith-woocommerce-ajax-product-filter-premium',
            'source'             => get_stylesheet_directory() . '/include/plugins/yith-woocommerce-ajax-product-filter-premium.zip',
            'required'           => true,
            'version'            => '3.11.2',
        ),
    );

    $config = array( /* The array to configure TGM Plugin Activation */ );

    tgmpa( $plugins, $config );
}