<?php

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    $opt_name = "zardkooh_options";

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'menu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Options', 'zardkooh' ),
        'page_title'           => __( 'Theme Options', 'zardkooh' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => false,
        // Use a asynchronous font on the front end or font string
        'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-portfolio',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => 'zardkooh',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => false,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => false,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => 'zardkooh_options',
        // Page slug used to denote the panel
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
         'footer_credit'     => false,                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!

        'use_cdn'              => true,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        //'compiler'             => true,

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'light',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );
	
	if( ! function_exists( 'zardkooh_get_shop_all_attributes' ) ) {
		function zardkooh_get_shop_all_attributes() {
			
			$all_attrebutes = array();
			
			$woo_attributes = wc_get_attribute_taxonomies();
			
			if ( is_array( $woo_attributes ) ) {
				foreach ( $woo_attributes as $attribute ) {
					$all_attrebutes[$attribute->attribute_name] = $attribute->attribute_label;
				}
			}
			
			return $all_attrebutes;
		}
	}

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     *
     * ---> START SECTIONS
     *
     */

    /*

        As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for


     */

    // -> START Fields
    Redux::setSection( $opt_name, array(
        'title'  => __( 'Styling', 'zardkooh' ),
        'id'     => 'styling_section',
        'icon'   => 'el-icon-brush el-icon-small',
        'fields' => array(
            array(
                'id'       => 'main_color',
                'type'     => 'color',
                'title'    => __( 'Main Color', 'zardkooh' ),
                'subtitle' => __( 'Pick a color for the main color.', 'zardkooh' ),
                'default'  => '#e5a906',
                'output'   => array(
                    'color' => '.footer-icons::before, .single-product-box-main h3::before,.social-icon::after, .single-product-section h2::before, .single-product-section h3::before, .woocommerce .woocommerce-breadcrumb::before, .woocommerce-breadcrumb::before, .zardkooh-widget .widget-title::before, .zardkooh-shipping-title::before, .woocommerce-checkout h3::before, .account-nav-box-avatar::before, .account-headline::before, .woocommerce-MyAccount-content h3::before, .product-page .products-swiper .object-headline::before, .form-share-input::before, .single-product-option.btn-wish.is-active:before, .account-page-return:before',
                    'background-color' => '.blog-post-box .blog-post-box-content .post-details .view-more, .swiper-pagination-bullet-active, .footer-cols-newslater .newsletter-btn, .dep-mega-menu > ul > li .dep-mega-menu-center ul li.has-label .description, .actions-box ul li.header-cart span.header-cart-count,.shop-page-header-sort li a.is-active, .zardkooh-comments-list-title .btn-add-comment, .zardkooh-comments-header-rate-line, .cart-shipping-progress-bar div span, .header-profile-dropdown-avatar, .woocommerce table.my_account_orders .button.view, .form-share-row-submit .btn-share, .remodal-loading-bullet, .woocommerce .woocommerce-form-login .woocommerce-form-login__submit, .woocommerce .woocommerce-form-register .woocommerce-form-register__submit, .woocommerce .woocommerce-ResetPassword .woocommerce-Button.button, .btn-send-verify, .blog-post-box .blog-post-box-content .post-details .view-more::before',
                    'border-color' => '.single-sticky-menu-items li:hover, .single-sticky-menu-items li.active, .woocommerce div.product .woocommerce-tabs ul.tabs li.active'
                )
            ),
			array(
                'id'       => 'body_background',
                'type'     => 'background',
                'title'    => __( 'Body Background', 'zardkooh' ),
                'desc'     => __( 'Design site body background.', 'zardkooh' ),
				'default'  => array(
					'background-color' => '#ffffff',
				),
				'output'   => array( 'background' => 'body')
            ),
			array(
                'id'       => 'body_color',
                'type'     => 'color',
                'title'    => __( 'Body Color', 'zardkooh' ),
                'desc'     => __( 'Choose site body text color.', 'zardkooh' ),
				'default'  => '#7f8994',
				'output'   => array( 'color' => 'body')
            ),
			array(
                'id'       => 'body_link_color',
                'type'     => 'color',
                'title'    => __( 'Links Color', 'zardkooh' ),
                'desc'     => __( 'Choose site links color.', 'zardkooh' ),
				'default'  => '#4a5f73',
				'output'   => array( 'color' => 'a')
            ),
			array(
                'id'       => 'body_link_hover_color',
                'type'     => 'color_rgba',
                'title'    => __( 'Links Hover Color', 'zardkooh' ),
                'desc'     => __( 'Choose site links hover color.', 'zardkooh' ),
				'default'  => array(
					'color'     => '#4a5f73',
					'alpha'     => 1
				),
				'output'   => array( 'color' => 'a:hover')
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'Footer', 'zardkooh' ),
		'id'    	=> 'footer_style_section',
		'subsection'=> true,
		'fields'	=> array(
			array(
                'id'       => 'footer_background',
                'type'     => 'background',
                'title'    => __( 'Background', 'zardkooh' ),
                'desc'     => __( 'Design your background to show on footer first section.', 'zardkooh' ),
				'default'  => array(
					'background-color' => 'transparent',
                    'background-repeat' => 'no-repeat',
                    'background-position' => 'center bottom',
                    'background-image' => get_template_directory_uri().'/assets/images/footer-bg.png',
                    'background size' => 'cover'
				),
				'output'   => array( 'background' => 'footer')
            ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'Shop', 'zardkooh' ),
		'id'    	=> 'shop_style_section',
		'subsection'=> true,
		'fields'	=> array(
			array(
                'id'       => 'add_to_cart_bg',
                'type'     => 'color',
                'title'    => __( 'Add To Cart Button Background Color', 'zardkooh' ),
                'subtitle' => __( 'Pick a color for the add to cart button background color.', 'zardkooh' ),
                'default'  => '#3ab54a',
				'output'   => array(
				    'background-color' => '.products-swiper-button, .woocommerce ul.products li.product .shop-loop-footer .button, .woocommerce div.product .product-page-side-cart button.button.alt ',
                    'color' => '.products-slider-container.carpet-swiper .products-swiper-button::after '
                )
            ),
			array(
                'id'       => 'add_to_cart_text',
                'type'     => 'color',
                'title'    => __( 'Add To Cart Button Text Color', 'zardkooh' ),
                'subtitle' => __( 'Pick a color for the add to cart button text color.', 'zardkooh' ),
                'default'  => '#ffffff',
				'output'   => array(
				    'color' => '.products-swiper-button, .woocommerce ul.products li.product .shop-loop-footer .button, .woocommerce div.product .product-page-side-cart button.button.alt ',
                    'background-color' => '.products-slider-container.carpet-swiper .products-swiper-button::after '
                )
            ),
            array(
                'id'       => 'offer_slider_color',
                'type'     => 'color',
                'title'    => __( 'Offer Slider Main Color', 'zardkooh' ),
                'subtitle' => __( 'Pick a color for the offer slider main color.', 'zardkooh' ),
                'default'  => '#E5A906',
                'output'   => array(
                    'background-color' => '.zardkooh-offer-slider::before, .zardkooh-offer-slider::after, .zardkooh-offer-slider-side .zardkooh-offer-slide-side:hover, .zardkooh-offer-slider-side .zardkooh-offer-slide-side.swiper-slide-active, .single-offer-counter .countdown-amount',
                )
            ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'General', 'zardkooh' ),
		'id'    	=> 'homepage_section',
		'icon'		=> 'el el-home',
		'fields'	=> array(
			array(
				'id' 		=> 'swiper_autoplay',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Enable Autoplay For Proudct Sliders', 'zardkooh' ),
				'subtitle'	=> __( 'Enable this option if you want to enable autoplay for products sliders.', 'zardkooh' ),
				'default'	=> 0,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
            array(
                'id' 		=> 'single_blog_image',
                'type' 		=> 'switch',
                'title' 	=> __( 'Single Blog Post Image', 'zardkooh' ),
                'subtitle'	=> __( 'Display featured image in single blog page.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
            array(
                'id' 		=> 'single_blog_sidebar',
                'type' 		=> 'switch',
                'title' 	=> __( 'Single Blog Post Sidebar', 'zardkooh' ),
                'subtitle'	=> __( 'Display sidebar in single blog page when blog sidebar is active.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'Top Bar', 'zardkooh' ),
		'id'    	=> 'top_bar_section',
		'icon'		=> 'el el-minus',
		'fields'	=> array(
			array(
				'id' 		=> 'top_bar',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Enable top bar', 'zardkooh' ),
				'subtitle'	=> __( 'Enable top bar for display custom messages.', 'zardkooh' ),
				'default'	=> 0,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'top_bar_text',
				'type' 		=> 'textarea',
				'title' 	=> __( 'Your Text', 'zardkooh' ),
				'required' => array( 'top_bar', '=', true )
			),
			array(
                'id'       => 'top_bar_link',
                'type'     => 'text',
                'title'    => __( 'Top Bar Link', 'zardkooh' ),
                'subtitle' => __( 'Insert your link for top bar', 'zardkooh' ),
				'required' => array( 'top_bar', '=', true )
            ),
			array(
                'id'       => 'top_bar_background',
                'type'     => 'background',
                'title'    => __( 'Background', 'zardkooh' ),
                'desc'     => __( 'Design your background to show on top bar.', 'zardkooh' ),
				'preview_height' => '60px',
				'output'   => array( 'background' => '.top-header-banner')
            ),
			array(
                'id'       => 'top_bar_text_color',
                'type'     => 'color',
                'title'    => __( 'Text Color', 'zardkooh' ),
                'subtitle' => __( 'Pick a color for the top bar text.', 'zardkooh' ),
                'default'  => '#000000',
				'output'   => array( 'color' => '.top-header-banner, .top-header-banner a')
            ),
			array(
                'id'       => 'top_bar_text_hover_color',
                'type'     => 'color_rgba',
                'title'    => __( 'Text Hover Color', 'zardkooh' ),
                'subtitle' => __( 'Pick a color for the top bar text hover.', 'zardkooh' ),
				'default'  => array(
					'color'     => '#ffffff',
					'alpha'     => 1
				),
				'output'   => array( 'color' => '.top-header-banner:hover, .top-header-banner a:hover')
            ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'Header', 'zardkooh' ),
		'id'    	=> 'header_section',
		'icon'		=> 'el el-bookmark',
		'fields'	=> array(
            array(
                'id'       => 'header_diff',
                'type'     => 'button_set',
                'title'    => __( 'Select Header Type', 'zardkooh' ),
                'subtitle' => __( 'Choose header style in inner pages.', 'zardkooh' ),
                'options'  => array(
                    'one' => __( 'Style 1', 'zardkooh' ),
                    'two' => __( 'Style 2', 'zardkooh' ),
                ),
                'default'  => 'one',
            ),
			array(
				'id'	=> 'logo',
				'type'	=> 'media',
				'title'	=> __( 'Your Logo', 'zardkooh' ),
				'default'  => array( 
					'url'	=> get_template_directory_uri().'/assets/images/logo.svg', 
					'width' => '119px',
					'height'=> '33px'
				),
				'desc'  => __( 'Choose your logo to show on header', 'zardkooh' ),
			),
            array(
                'id'	=> 'logo-footer',
                'type'	=> 'media',
                'title'	=> __( 'Your Footer Logo', 'zardkooh' ),
                'default'  => array(
                    'url'	=> get_template_directory_uri().'/assets/images/logo-footer.svg',
                    'width' => '160px',
                    'height'=> '40px'
                ),
                'desc'  => __( 'Choose your logo to show on footer', 'zardkooh' ),
            ),
			array(
				'id'	=> 'favicon',
				'type'	=> 'media',
				'title'	=> __( 'Your Favicon', 'zardkooh' ),
				'default'  => array( 'url' => get_template_directory_uri().'/assets/images/favicon.png' ),
				'desc'  => __( 'Choose your favicon to show on browser.', 'zardkooh' ),
			),
		)
	) );
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'Main Menu', 'zardkooh' ),
		'id'    	=> 'main_menu_section',
		'icon'		=> 'el el-list',
		'subsection'=> true,
		'fields'	=> array(
			array(
				'id' 		=> 'department_menu',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Dispaly Department Menu', 'zardkooh' ),
				'subtitle'	=> __( 'Dispaly department menu in main menu.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
            array(
                'id' 		=> 'department_menu_products',
                'type' 		=> 'switch',
                'title' 	=> __( 'Dispaly Random Products On Department Menu', 'zardkooh' ),
                'subtitle'	=> __( 'Dispaly random products of category on department menu. Select category in menu described on product help file.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
            array(
                'id'        => 'department_products_count',
                'type'      => 'text',
                'validate'	=> 'numeric',
                'title'     => __( 'Number Of Products To Show', 'zardkooh' ),
                'subtitle'  => __( 'Set maximum number of products to show. Maximum is 30 item.', 'zardkooh' ),
                'default'   => 8,
                'required'	=> array( 'department_menu_products', '=', true )
            ),
            array(
                'id' 		=> 'diff_department_menu',
                'type' 		=> 'switch',
                'title' 	=> __( 'Different Main Menu For Each Department', 'zardkooh' ),
                'subtitle'	=> __( 'Dispaly different main menu on each department pages.', 'zardkooh' ),
                'description' => __( 'Menu location will added so you can add your desired menu.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
            array(
                'id' 		=> 'diff_department_menu_mobile',
                'type' 		=> 'switch',
                'title' 	=> __( 'Dispaly Different Department Menu On Mobile', 'zardkooh' ),
                'subtitle'	=> __( 'Dispaly different main menu on each department pages on mobile.', 'zardkooh' ),
                'description' => __( 'Menu location will added so you can add your desired menu.', 'zardkooh' ),
                'default'	=> 0,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
                'required'  => array( 'diff_department_menu', '=', true )
            ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
        'title'		 => __( 'Shop', 'zardkooh' ),
        'id'    	 => 'shop_section',
        'icon'  	 => 'el el-shopping-cart',
        'fields'	 => array(
			array(
				'id' 		=> 'price_html',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Use Default Woocommerce Price Function', 'zardkooh' ),
				'subtitle'	=> __( 'Enable this option if you have using modify price plugins and have problem with price display.', 'zardkooh' ),
				'default'	=> 0,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
                'id'       => 'zero_price',
                'type'     => 'text',
                'title'    => __( 'Zero Price Text', 'zardkooh' ),
                'subtitle' => __( 'Insert your desired text for display when product price is 0 or empty.', 'zardkooh' ),
				'default'  => __( 'Call Us', 'zardkooh' ),
            ),
			array(
				'id' 		=> 'outofstock_end',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Display Out Of Stock Products At End (Test)', 'zardkooh' ),
				'subtitle'	=> __( 'Enable this option if you want to out of stock products display at the end of products list on product categories pages.', 'zardkooh' ),
				'default'	=> 0,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'display_options',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Display Shop List/Grid', 'zardkooh' ),
				'subtitle'	=> __( 'Enable this option if you want to show options for display products in list or grid.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
                'id'       => 'default_display',
                'type'     => 'button_set',
                'title'    => __( 'Select Default Display Type', 'zardkooh' ),
                'subtitle' => __( 'Display products in list view or grid view by default.', 'zardkooh' ),
                'options'  => array(
                    'list' => __( 'List', 'zardkooh' ),
                    'grid' => __( 'Grid', 'zardkooh' ),
                ),
                'default'  => 'grid',
            ),
			array(
				'id' 		=> 'loop_colors',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Display Porudct Colors', 'zardkooh' ),
				'subtitle'	=> __( 'Display product colors on shop pages.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
                'id'       => 'loop_color_attribute',
                'type'     => 'select',
				'data'	   => 'callback',
                'args'     => array( 'zardkooh_get_shop_all_attributes' ),
                'title'    => __( 'Select Color Attribute', 'zardkooh' ),
                'desc'     => __( 'Select attribute that belongs to color value in your shop.', 'zardkooh' ),
				'required' => array( 'loop_colors', '=', true )
            ),
            array(
                'id'       => 'shop_images_size',
                'type'     => 'button_set',
                'title'    => __( 'Select Shop Images Type', 'zardkooh' ),
                'subtitle' => __( 'Choose display product images in shop products in full size or in optimized version.', 'zardkooh' ),
                'options'  => array(
                    'shop_catalog'	=> __( 'General Size', 'zardkooh' ),
                    'thumbnail'		=> __( 'Optimized Size', 'zardkooh' ),
                    'full'			=> __( 'Original Size', 'zardkooh' ),
                ),
                'default'  => 'shop_catalog',
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'Product Page', 'zardkooh' ),
		'id'    	=> 'product_page_section',
		'icon'		=> 'el el-laptop',
		'fields'	=> array(
			array(
				'id'       => 'single_schema',
				'type'     => 'switch',
				'title'    => __( 'Enable Product Schema', 'zardkooh' ),
				'subtitle' => __( 'Enable to show product schema in single product page for google seo.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id'       => 'show_brand',
				'type'     => 'switch',
				'title'    => __( 'Display Product Brand', 'zardkooh' ),
				'subtitle' => __( 'Enable to show brand on single product page. YITH WooCommerce Brands Add-on Plugin must be activated.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'show_sku',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Dispaly Product SKU', 'zardkooh' ),
				'subtitle'	=> __( 'Dispaly product SKU in product page', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'show_category',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Dispaly Product Category', 'zardkooh' ),
				'subtitle'	=> __( 'Dispaly product category in product page', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'show_tag',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Dispaly Product Tag', 'zardkooh' ),
				'subtitle'	=> __( 'Dispaly product tag in product page', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'single_stock',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Display Stock Quantity', 'zardkooh' ),
				'subtitle'	=> __( 'Display product stock quantity on single product page.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'single_features',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Display Product Features', 'zardkooh' ),
				'subtitle'	=> __( 'Display product features on single product page.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'show_share',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Dispaly Product Share Section', 'zardkooh' ),
				'subtitle'	=> __( 'Dispaly product share section in product page', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
            array(
                'id' 		=> 'show_price_change',
                'type' 		=> 'switch',
                'title' 	=> __( 'Dispaly Product Price Changes', 'zardkooh' ),
                'subtitle'	=> __( 'Dispaly product price changes on product page', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
            array(
                'id' 		=> 'auto_price_change',
                'type' 		=> 'switch',
                'title' 	=> __( 'Enable Auto Product Price Changes', 'zardkooh' ),
                'subtitle'	=> __( 'Enable this option to record product price changes automatically. Disable if you want add price on product page.', 'zardkooh' ),
                'default'	=> 0,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
            array(
                'id' 		=> 'show_qrcode',
                'type' 		=> 'switch',
                'title' 	=> __( 'Dispaly Product QR Code Section', 'zardkooh' ),
                'subtitle'	=> __( 'Dispaly product qr code section in product page. QR Code Woocommerce plugin must be activated.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
		)
	) );
	
	/*Redux::setSection( $opt_name, array(
		'title'		=> __( 'Features', 'zardkooh' ),
		'id'    	=> 'product_features_section',
		'icon'		=> 'el el-lines',
		'subsection'=> true,
		'fields'	=> array(
			array(
				'id' 		=> 'productfeatures',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Enable Features Boxs', 'zardkooh' ),
				'subtitle'	=> __( 'Enable Features Boxs In Product Page', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
                'id'       => 'p_features1_title',
                'type'     => 'text',
                'title'    => __( 'Feature Title', 'zardkooh' ),
                'subtitle' => __( 'Insert your title for this feature.', 'zardkooh' ),
				'default'  => __( 'Ontime Delivery Garanty', 'zardkooh' ),
				'required' => array( 'productfeatures', '=', true )
            ),
			array(
                'id'       => 'p_features1_link',
                'type'     => 'text',
                'title'    => __( 'Feature Link', 'zardkooh' ),
                'subtitle' => __( 'Insert your link for this feature.', 'zardkooh' ),
				'required' => array( 'productfeatures', '=', true )
            ),
			array(
				'id'		=> 'p_features1',
				'type'		=> 'media',
				'title'		=> __( 'Your Image Or SVG Icon', 'zardkooh' ),
				'default'	=> array( 'url' => get_template_directory_uri().'/assets/images/p_features-1.svg' ),
				'desc'		=> __( 'Choose your image or SVG icon to show', 'zardkooh' ),
				'required'	=> array( 'productfeatures', '=', true )
			),
			array(
                'id'       => 'p_features2_title',
                'type'     => 'text',
                'title'    => __( 'Feature Title', 'zardkooh' ),
                'subtitle' => __( 'Insert your title for this feature.', 'zardkooh' ),
				'default'  => __( 'After Buy Services', 'zardkooh' ),
				'required' => array( 'productfeatures', '=', true )
            ),
			array(
                'id'       => 'p_features2_link',
                'type'     => 'text',
                'title'    => __( 'Feature Link', 'zardkooh' ),
                'subtitle' => __( 'Insert your link for this feature.', 'zardkooh' ),
				'required' => array( 'productfeatures', '=', true )
            ),
			array(
				'id'		=> 'p_features2',
				'type'		=> 'media',
				'title'		=> __( 'Your Image Or SVG Icon', 'zardkooh' ),
				'default'	=> array( 'url' => get_template_directory_uri().'/assets/images/p_features-2.svg' ),
				'desc'		=> __( 'Choose your image or SVG icon to show', 'zardkooh' ),
				'required'	=> array( 'productfeatures', '=', true )
			),
			array(
                'id'       => 'p_features3_title',
                'type'     => 'text',
                'title'    => __( 'Feature Title', 'zardkooh' ),
                'subtitle' => __( 'Insert your title for this feature.', 'zardkooh' ),
				'default'  => __( 'Return Money Garanty', 'zardkooh' ),
				'required' => array( 'productfeatures', '=', true )
            ),
			array(
                'id'       => 'p_features3_link',
                'type'     => 'text',
                'title'    => __( 'Feature Link', 'zardkooh' ),
                'subtitle' => __( 'Insert your link for this feature.', 'zardkooh' ),
				'required' => array( 'productfeatures', '=', true )
            ),
			array(
				'id'		=> 'p_features3',
				'type'		=> 'media',
				'title'		=> __( 'Your Image Or SVG Icon', 'zardkooh' ),
				'default'	=> array( 'url' => get_template_directory_uri().'/assets/images/p_features-3.svg' ),
				'desc'		=> __( 'Choose your image or SVG icon to show', 'zardkooh' ),
				'required'	=> array( 'productfeatures', '=', true )
			),
			array(
                'id'       => 'p_features4_title',
                'type'     => 'text',
                'title'    => __( 'Feature Title', 'zardkooh' ),
                'subtitle' => __( 'Insert your title for this feature.', 'zardkooh' ),
				'default'  => __( '7 Day Product Return', 'zardkooh' ),
				'required' => array( 'productfeatures', '=', true )
            ),
			array(
                'id'       => 'p_features4_link',
                'type'     => 'text',
                'title'    => __( 'Feature Link', 'zardkooh' ),
                'subtitle' => __( 'Insert your link for this feature.', 'zardkooh' ),
				'required' => array( 'productfeatures', '=', true )
            ),
			array(
				'id'		=> 'p_features4',
				'type'		=> 'media',
				'title'		=> __( 'Your Image Or SVG Icon', 'zardkooh' ),
				'default'	=> array( 'url' => get_template_directory_uri().'/assets/images/p_features-4.svg' ),
				'desc'		=> __( 'Choose your image or SVG icon to show', 'zardkooh' ),
				'required'	=> array( 'productfeatures', '=', true )
			),
		)
	) );*/
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'Share', 'zardkooh' ),
		'id'    	=> 'share_section',
		'icon'		=> 'el el-envelope',
		'subsection'=> true,
		'fields'	=> array(
			array(
                'id'       => 'sendtofriend_sub',
                'type'     => 'text',
                'title'    => __( 'Send To Friend Email Subject', 'zardkooh' ),
                'desc'     => __( 'Insert your email subject sending on send to friend section.', 'zardkooh' ),
				'default'  => __( 'See This Awesome Product!', 'zardkooh' ),
            ),
			array(
                'id'       => 'sendtofriend_text',
                'type'     => 'textarea',
                'title'    => __( 'Send To Friend Email Body', 'zardkooh' ),
                'desc'     => __( 'Insert your message text for sending on send to friend section. Product link placed at the end of email.', 'zardkooh' ),
				'default'  => __( 'Hi.</br>I think you are interested to this product. Check below link:', 'zardkooh' ),
            ),
		)
	) );

    Redux::setSection( $opt_name, array(
        'title'		=> __( 'Titles', 'zardkooh' ),
        'id'    	=> 'product_page_titles_section',
        'icon'		=> 'el el-font',
        'subsection'=> true,
        'fields'	=> array(
            array(
                'id'       => 'size_guide_title',
                'type'     => 'text',
                'title'    => __( 'Size Guide Title', 'zardkooh' ),
                'subtitle' => __( 'Insert your title for size guide section.', 'zardkooh' ),
                'default'  => __( 'Size Guide','zardkooh' ),
            ),
            array(
                'id'       => 'together_items_title',
                'type'     => 'text',
                'title'    => __( 'Together Items Title', 'zardkooh' ),
                'subtitle' => __( 'Insert your title for together items tab.', 'zardkooh' ),
                'default'  => __( 'Together Items','zardkooh' ),
            ),
            array(
                'id'       => 'product_garanty_title',
                'type'     => 'text',
                'title'    => __( 'Product Garanty Title', 'zardkooh' ),
                'subtitle' => __( 'Insert your title for product garanty tab.', 'zardkooh' ),
                'default'  => __( 'Product Garanty','zardkooh' ),
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Comment', 'zardkooh' ),
        'id'     => 'comment_section',
        'icon'   => 'el el-comment',
        'fields' => array(
            array(
                'id' 		=> 'zardkooh_comment',
                'type' 		=> 'switch',
                'title' 	=> __( 'Using Zardkooh Special Comment System', 'zardkooh' ),
                'subtitle'	=> __( 'Using Zardkooh special comment system instead of default woocommerce comment system.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
			array(
				'id' 		=> 'zardkooh_comment_login',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Force Login For Submit Comment', 'zardkooh' ),
				'subtitle'	=> __( 'Enable this option if you want logged in user can submit comments.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
                'id'       => 'add_comment_page',
                'type'     => 'select',
                'data'     => 'pages',
                'title'    => __( 'Select Add Comment Page', 'zardkooh' ),
                'desc'     => __( 'Select page that has [cando-add-comment] shortcode.', 'zardkooh' ),
            ),
			array(
                'id'       => 'comment_rules',
                'type'     => 'select',
                'data'     => 'pages',
                'title'    => __( 'Select Comment Rules Page', 'zardkooh' ),
                'desc'     => __( 'Select page that includes your site rules for submit comment.', 'zardkooh' ),
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Compare', 'zardkooh' ),
        'id'     => 'compare_section',
        'icon'   => 'el el-tasks',
        'fields' => array(
			array(
				'id'       => 'zardkooh_compare',
				'type'     => 'switch',
				'title'    => __( 'Enable Theme Compare Function', 'zardkooh' ),
				'subtitle' => __( 'Enable to use special compare system.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
                'id'       => 'compare_page',
                'type'     => 'select',
                'data'     => 'pages',
                'title'    => __( 'Select Compare Page', 'zardkooh' ),
                'desc'     => __( 'Select page that has [cando-compare-list] shortcode.', 'zardkooh' ),
				'required' => array( 'zardkooh_compare', '=', true )
            ),
			array(
				'id'      	=> 'display_dimensions',
				'type'    	=> 'switch',
				'title'   	=> __( 'Display Dimensions Information', 'zardkooh' ),
				'subtitle'	=> __( 'Enable to show dimensions information on compare page.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
				'required'	=> array( 'zardkooh_compare', '=', true )
			),
        )
    ) );
	
	/*Redux::setSection( $opt_name, array(
        'title'  => __( 'Account', 'zardkooh' ),
        'id'     => 'account_section',
        'icon'   => 'el el-torso',
        'fields' => array(
			array(
				'id' 		=> 'modal_login',
				'type' 		=> 'switch',
				'title' 	=> __( 'Use Popup Login', 'zardkooh' ),
				'subtitle'	=> __( 'Use popup login instead of login page.', 'zardkooh' ),
				'default'	=> 0,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'account_downloads',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Display Downloads', 'zardkooh' ),
				'subtitle'	=> __( 'Display downloads tab on account page.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'account_wishlist',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Display Wishlist', 'zardkooh' ),
				'subtitle'	=> __( 'Display wishlist tab on account page.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' 		=> 'account_comments',
				'type' 		=> 'switch', 
				'title' 	=> __( 'Display Comments', 'zardkooh' ),
				'subtitle'	=> __( 'Display comments tab on account page.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
        )
    ) );*/
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Checkout', 'zardkooh' ),
        'id'     => 'checkout_section',
        'icon'   => 'el el-usd',
        'fields' => array(
            array(
                'id' 		=> 'checkout_plugin',
                'type' 		=> 'switch',
                'title' 	=> __( 'Using Checkout Manager Plugins', 'zardkooh' ),
                'subtitle'	=> __( 'If you want to use checkout manager plugins to edit checkout fields, enable this option. After enable this option you can not use theme mobile field.', 'zardkooh' ),
                'default'	=> 0,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
            array(
                'id' 		=> 'mobile_checkout',
                'type' 		=> 'switch',
                'title' 	=> __( 'Mobile Field On Checkout Page', 'zardkooh' ),
                'subtitle'	=> __( 'Enable to show mobile field on checkout page for users.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
            array(
                'id' 		=> 'mobile_required',
                'type' 		=> 'switch',
                'title' 	=> __( 'Make Mobile Field Required', 'zardkooh' ),
                'subtitle'	=> __( 'Enable to make mobile field required on checkout page for users.', 'zardkooh' ),
                'default'	=> 0,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
                'required'	=> array( 'mobile_checkout', '=', true )
            ),
            array(
                'id' 		=> 'persian_woo_mobile',
                'type' 		=> 'switch',
                'title' 	=> __( 'Persian Woocommece SMS', 'zardkooh' ),
                'subtitle'	=> __( 'Enable this option to use zardkooh mobile field for sending customer order sms.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
                'required'	=> array( 'mobile_checkout', '=', true )
            ),
            array(
                'id' 		=> 'cart_shipping_process',
                'type' 		=> 'switch',
                'title' 	=> __( 'Enable Shipping Process Bar', 'zardkooh' ),
                'subtitle'	=> __( 'If you have free shipping option in your shop, you can enable this option.', 'zardkooh' ),
                'default'	=> 0,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
            array(
                'id' 		=> 'cart_shipping_free',
                'type' 		=> 'text',
                'title' 	=> __( 'Free Shipping Cart Total', 'zardkooh' ),
                'subtitle'	=> __( 'Minimum cart total to have free shipping.', 'zardkooh' ),
                'desc'      => __( 'This value must be equal to value that set in woocommerce shipping options for free method.', 'zardkooh' ),
                'required'  => array( 'cart_shipping_process', '=', true ),
                'validate'  => 'numeric'
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Footer', 'zardkooh' ),
        'id'     => 'footer_section',
        'icon'   => 'el el-minus',
        'fields' => array(		
			array(
                'id'       => 'footer_phone',
                'type'     => 'text',
                'title'    => __( 'Footer Phone Number', 'zardkooh' ),
                'subtitle' => __( 'Insert your footer phone number', 'zardkooh' ),
            ),
			array(
                'id'       => 'footer_phone_p',
                'type'     => 'select',
                'data'     => 'pages',
                'title'    => __( 'Select Contact Page', 'zardkooh' ),
                'desc'     => __( 'Select page that has contact information.', 'zardkooh' ),
            ),
			array(
                'id'       => 'footer_hours',
                'type'     => 'text',
                'title'    => __( 'Footer Work Hours', 'zardkooh' ),
                'subtitle' => __( 'Insert your footer work hours.', 'zardkooh' ),
            ),
			array(
                'id'       => 'footer_address',
                'type'     => 'text',
                'title'    => __( 'Footer Address', 'zardkooh' ),
                'subtitle' => __( 'Insert your footer address', 'zardkooh' ),
            ),
			array(
                'id'       => 'copyright',
                'type'     => 'text',
                'title'    => __( 'CopyRight Text', 'zardkooh' ),
                'subtitle' => __( 'Insert your copyright text', 'zardkooh' ),
            ),
			array(
                'id'       => 'rasaneh',
                'type'     => 'textarea',
                'title'    => __( 'Resaneh Code', 'zardkooh' ),
                'desc'     => __( 'Insert your Resaneh code', 'zardkooh' ),
            ),
			array(
                'id'       => 'enamad',
                'type'     => 'textarea',
                'title'    => __( 'Enamad Code', 'zardkooh' ),
                'desc'     => __( 'Insert your Enamad code', 'zardkooh' ),
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
		'title'		=> __( 'Newslater', 'zardkooh' ),
		'id'    	=> 'footer_newslater_section',
		'icon'		=> 'el el-bookmark',
		'subsection'=> true,
		'fields'	=> array(
			array(
                'id'       => 'footernewslater_title',
                'type'     => 'text',
                'title'    => __( 'Footer Subscribe Form Title', 'zardkooh' ),
                'subtitle' => __( 'Insert your footer subscribe form title', 'zardkooh' ),
				'default'  => __( 'Notify of offers and new products:', 'zardkooh' ),
            ),
			array(
                'id'       => 'footernewslater_email_mobile',
                'type'     => 'button_set',
                'title'    => __( 'Select Newslater Type', 'zardkooh' ),
                'subtitle' => __( 'You want to get email or phone number from customers in newslater?', 'zardkooh' ),
                'options'  => array(
                    'email' => __( 'Email', 'zardkooh' ),
                    'mobile' => __( 'Mobile', 'zardkooh' ),
                ),
                'default'  => 'email',
            ),
		)
	) );
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Social', 'zardkooh' ),
        'id'     => 'social_section',
        'icon'   => 'el el-share',
        'fields' => array(
			array(
                'id'       => 'social-facebook',
                'type'     => 'text',
                'title'    => __( 'Facebook', 'zardkooh' ),
                'subtitle' => __( 'Insert your facebook link', 'zardkooh' ),
            ),
			array(
                'id'       => 'social-twitter',
                'type'     => 'text',
                'title'    => __( 'Twitter', 'zardkooh' ),
                'subtitle' => __( 'Insert your twitter link', 'zardkooh' ),
            ),
			array(
                'id'       => 'social-gmail',
                'type'     => 'text',
                'title'    => __( 'Google Plus', 'zardkooh' ),
                'subtitle' => __( 'Insert your googleplus link', 'zardkooh' ),
            ),
			array(
                'id'       => 'social-instagram',
                'type'     => 'text',
                'title'    => __( 'Instagram', 'zardkooh' ),
                'subtitle' => __( 'Insert your instagram link', 'zardkooh' ),
            ),
			array(
                'id'       => 'social-telegram',
                'type'     => 'text',
                'title'    => __( 'Telegram', 'zardkooh' ),
                'subtitle' => __( 'Insert your telegram link', 'zardkooh' ),
            ),
			array(
                'id'       => 'social-whatsapp',
                'type'     => 'text',
                'title'    => __( 'Whatsapp', 'zardkooh' ),
                'subtitle' => __( 'Insert your whatsapp link', 'zardkooh' ),
            ),
			array(
                'id'       => 'social-linkedin',
                'type'     => 'text',
                'title'    => __( 'Linkedin', 'zardkooh' ),
                'subtitle' => __( 'Insert your linkedin link', 'zardkooh' ),
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Map', 'zardkooh' ),
        'id'     => 'map_section',
        'icon'   => 'el el-map-marker',
        'fields' => array(
            array(
                'id' 		=> 'checkout_map',
                'type' 		=> 'switch',
                'title' 	=> __( 'Enable Map In Checkout Page', 'zardkooh' ),
                'subtitle'	=> __( 'Display location on map in checkout page.', 'zardkooh' ),
                'default'	=> 1,
                'on' 		=> __( 'Enable', 'zardkooh' ),
                'off' 		=> __( 'Disable', 'zardkooh' ),
            ),
			array(
                'id'       => 'map_api_key',
                'type'     => 'text',
                'title'    => __( 'Map API Key', 'zardkooh' ),
                'subtitle' => __( 'Insert your selected map api key.', 'zardkooh' ),
            ),
			array(
                'id'       => 'map_lat',
                'type'     => 'text',
                'title'    => __( 'Default Map Latitude', 'zardkooh' ),
                'subtitle' => __( 'Insert your desired default map latitude. Default for Tehran map is: 35.6892', 'zardkooh' ),
				'default'  => '35.6892'
            ),
			array(
                'id'       => 'map_lng',
                'type'     => 'text',
                'title'    => __( 'Default Map Longitude', 'zardkooh' ),
                'subtitle' => __( 'Insert your desired default map longitude. Default for Tehran map is: 51.3890', 'zardkooh' ),
				'default'  => '51.3890'
            ),
			array(
				'id'	   => 'map_pin_icon',
				'type'	   => 'media',
				'title'	   => __( 'Your Pin Icon', 'zardkooh' ),
				'default'  => array( 'url' => get_template_directory_uri().'/assets/images/map-pin.png' ),
				'desc'	   => __( 'Choose your pin icon to display on CedarMap.', 'zardkooh' ),
			),
        )
    ) );
	
	/*Redux::setSection( $opt_name, array(
        'title'  => __( 'Blog', 'zardkooh' ),
        'id'     => 'blog_section',
        'icon'   => 'el el-book',
        'fields' => array(
			array(
                'id'       => 'video_cat',
                'type'     => 'select',
				'data'     => 'categories',
                'title'    => __( 'Video Category', 'zardkooh' ),
                'subtitle' => __( 'Select video category in your posts.', 'zardkooh' ),
				'args'  => array(
					'hide_empty' => false,
				)
            ),
        )
    ) );*/
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Map', 'zardkooh' ),
        'id'     => 'map_section',
        'icon'   => 'el el-map-marker',
        'fields' => array(
			array(
                'id'       => 'map_api_key',
                'type'     => 'text',
                'title'    => __( 'Map API Key', 'zardkooh' ),
                'subtitle' => __( 'Insert your selected map api key.', 'zardkooh' ),
            ),
			array(
                'id'       => 'map_lat',
                'type'     => 'text',
                'title'    => __( 'Default Map Latitude', 'zardkooh' ),
                'subtitle' => __( 'Insert your desired default map latitude. Default for Tehran map is: 35.6892', 'zardkooh' ),
				'default'  => '35.6892'
            ),
			array(
                'id'       => 'map_lng',
                'type'     => 'text',
                'title'    => __( 'Default Map Longitude', 'zardkooh' ),
                'subtitle' => __( 'Insert your desired default map longitude. Default for Tehran map is: 51.3890', 'zardkooh' ),
				'default'  => '51.3890'
            ),
			array(
				'id'	   => 'map_pin_icon',
				'type'	   => 'media',
				'title'	   => __( 'Your Pin Icon', 'zardkooh' ),
				'default'  => array( 'url' => get_template_directory_uri().'/assets/images/map-pin.png' ),
				'desc'	   => __( 'Choose your pin icon to display on CedarMap Or Map.ir', 'zardkooh' ),
			),
			array(
				'id'		=> 'mapir_address',
				'type'		=> 'switch',
				'title'		=> __( 'Address Field Text', 'zardkooh' ),
				'subtitle'	=> __( 'If enable this option, when user submit location on map.ir service, address field will compelete with address that get from map.', 'zardkooh' ),
				'default'	=> 1,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Google reCaptcha', 'zardkooh' ),
        'id'     => 'captcha_section',
        'icon'   => 'el el-lock',
        'fields' => array(
			array(
				'id'       => 'enable_reCaptcha',
				'type'     => 'switch',
				'title'    => __( 'Enable Google Recaptcha', 'zardkooh' ),
				'subtitle' => __( 'Enable to show google reCaptcha on popup login form.', 'zardkooh' ),
				'default'	=> 0,
				'on' 		=> __( 'Enable', 'zardkooh' ),
				'off' 		=> __( 'Disable', 'zardkooh' ),
			),
			array(
				'id' => 'recaptcha_info',
				'type' => 'info',
				'title' => __('Google reCaptcha', 'zardkooh'),
				'style' => 'info',
				'desc' => __('<p>If you do not have keys already then visit <kbd><a href = "https://www.google.com/recaptcha/admin">https://www.google.com/recaptcha/admin</a></kbd></p>', 'zardkooh')
			),
			array(
                'id'       => 'recaptha_site_key',
                'type'     => 'text',
                'title'    => __( 'Site Key', 'zardkooh' ),
                'subtitle' => __( 'Insert your reCaptcha site key', 'zardkooh' ),
				'required' => array( 'enable_reCaptcha', '=', true )
            ),
			array(
                'id'       => 'recaptha_secret_key',
                'type'     => 'text',
                'title'    => __( 'Secret Key', 'zardkooh' ),
                'subtitle' => __( 'Insert your reCaptcha secret key', 'zardkooh' ),
				'required' => array( 'enable_reCaptcha', '=', true )
            ),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
        'title'  => __( 'Others', 'zardkooh' ),
        'id'     => 'others_section',
        'icon'   => 'el el-cog',
        'fields' => array(
			array(
				'id'	=> 'img_404',
				'type'	=> 'media',
				'title'	=> __( 'Your 404 Page Image', 'zardkooh' ),
				'default'  => array( 'url' => get_template_directory_uri().'/assets/images/error-404.svg' ),
				'desc'  => __( 'Choose your image to show on 404 page.', 'zardkooh' ),
			),
        )
    ) );
	
	Redux::setSection( $opt_name, array(
            'title' => __('Custom Code', 'zardkooh'),
            'icon'   => 'el el-css',
            'fields'    => array(

                array(
					'title'		=> __('Custom CSS', 'zardkooh'),
                    'subtitle'	=> __('Paste your custom CSS code here. The code will be added to the header of your site.', 'zardkooh'),
                    'id'		=> 'zardkooh_custom_css',
                    'type'		=> 'ace_editor',
                    'mode'		=> 'css',
                ),
				array(
					'title'		=> __('Mobile Custom CSS', 'zardkooh'),
                    'subtitle'	=> __('Paste your custom CSS code here. The code will be added to the header of your site in mobile view.', 'zardkooh'),
                    'id'		=> 'zardkooh_custom_css_mobile',
                    'type'		=> 'ace_editor',
                    'mode'		=> 'css',
                ),
				array(
					'title'		=> __('Header JavaScript Code', 'zardkooh'),
                    'subtitle'	=> __('Here is the place to paste any JS code you might want to add to be loaded in the header of your website.', 'zardkooh'),
                    'id'		=> 'zardkooh_custom_js_header',
                    'type'		=> 'ace_editor',
                    'mode'		=> 'javascript',
                ),
                array(
					'title'		=> __('Footer JavaScript Code', 'zardkooh'),
                    'subtitle'	=> __('Here is the place to paste any JS code you might want to add to be loaded in the footer of your website.', 'zardkooh'),
                    'id'		=> 'zardkooh_custom_js_footer',
                    'type'		=> 'ace_editor',
                    'mode'		=> 'javascript',
                ),
        )
    ) );

    /*
     * <--- END SECTIONS
     */
