<?php
/**
 * Cando Offer Slider Template
 */

global $zardkooh_options;
$endtime	= current_time( 'timestamp' );
$endtime	= date('Y-m-d 23:59:59',$endtime);
?>
<div class="zardkooh-offer-slider">
    <div class="zardkooh-offer-slider-header">
        <span class="zardkooh-offer-slider-header-title"><?php echo $title; ?></span>
        <?php if ( !zardkooh_is_mobile() ) { ?>
        <div id="offerclock" class="single-offer-counter"></div>
        <script type="text/javascript">
            jQuery(function($){
                $('#offerclock').countdown("<?php echo $endtime;?>", function(event) {
                    $(this).html(event.strftime('<div class="countdown-section"><span class="countdown-amount">%H</span><span class="countdown-label"><?php echo __('Hour','zardkooh');?></span></div><div class="countdown-section"><span class="countdown-amount">%M</span><span class="countdown-label"><?php echo __('Minute','zardkooh');?></span></div><div class="countdown-section"><span class="countdown-amount">%S</span><span class="countdown-label"><?php echo __('Second','zardkooh');?></span></div>'));
                });
            });
        </script>
        <?php } ?>
    </div>
    <div class="zardkooh-offer-slider-content">
        <div class="zardkooh-offer-slider-main">
            <?php if ( !zardkooh_is_mobile() ) { ?>
            <div class="swiper-container offer-slider-main-id">
                <div class="swiper-wrapper">
                    <?php
                    }
                    $count = 1;
                    foreach ($all_products as $product_id ) {
                        $product	= wc_get_product( $product_id );
                        $features	= get_post_meta( $product->get_id(), 'main_features', true);

                        ?>
                        <a href="<?php echo get_permalink($product_id); ?>" class="swiper-slide zardkooh-offer-slide-main">

                            <img src="<?php echo zardkooh_get_product_img($product); ?>" alt="<?php echo $product->get_title(); ?>" width="250" height="250">
                            <div class="offer-slider-content">
                                <h3><?php echo $product->get_title(); ?></h3>
                                <div class="offer-slider-price">
                                    <?php echo $product->get_price_html(); ?>
                                </div>
                                <?php if ( is_array($features) ) { ?>
                                    <ul class="offer-slider-desc">
                                        <?php
                                        $feature_count = 1;
                                        foreach ( $features as $feature ) {
                                            if ( $feature_count < 5 ) {
                                                echo '<li><span class="product-meta-title">'.$feature['title'].': </span><span class="product-meta-value">'.$feature['value'].'</span></li>';
                                            }
                                            $feature_count++;
                                        }
                                        ?>
                                    </ul>
                                <?php } ?>
                                <span class="products-swiper-button"><?php echo _e('View Product','zardkooh');?></span>
                                <div id="offerclocksingle<?php echo $count; ?>" class="single-offer-counter"></div>
                                <script type="text/javascript">
                                    jQuery(function($){
                                        $('#offerclocksingle<?php echo $count; $count++; ?>').countdown("<?php echo $endtime;?>", function(event) {
                                            $(this).html(event.strftime('<div class="countdown-section"><span class="countdown-amount">%H</span><span class="countdown-label"><?php echo __('Hour','zardkooh');?></span></div><div class="countdown-section"><span class="countdown-amount">%M</span><span class="countdown-label"><?php echo __('Minute','zardkooh');?></span></div><div class="countdown-section last-countdown-section"><span class="countdown-amount">%S</span><span class="countdown-label"><?php echo __('Second','zardkooh');?></span></div>'));
                                        });
                                    });
                                </script>
                            </div>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php if ( !zardkooh_is_mobile() ) { ?>
            <div class="zardkooh-offer-slider-side">
                <div class="swiper-container offer-slider-thumbs-id">
                    <div class="swiper-wrapper">
                        <?php
                        foreach ($all_products as $product_id ) {
                            $product = wc_get_product( $product_id );
                            ?>
                            <div class="swiper-slide zardkooh-offer-slide-side">
                                <?php if (zardkooh_get_product_discount_percent($product)) { ?>
                                <span class="zardkooh-offer-side-discount">
                                    <?php echo zardkooh_get_product_discount_percent($product); ?><?php echo _e(' Discount','zardkooh');?>
                                </span>
                                <?php } ?>
                                <div class="zardkooh-offer-side-image">
                                    <img src="<?php echo zardkooh_get_product_img($product, array(64,64)); ?>" alt="<?php echo $product->get_title(); ?>" width="80" height="80">
                                </div>

                                <div class="zardkooh-offer-side-title">
                                    <span class="offer-side-product-title"><?php echo $product->get_title(); ?></span>
                                    <span><?php echo wc_price($product->get_price()); ?></span>
                                </div>
                            </div>
                    <?php } ?>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>