<?php
/**
 * Cando Single Product Box Template
 */
 ?>
<section class="zardkooh-single-product-box <?php echo $box_style; ?>">
	<div class="single-product-box-side">
		<img alt="<?php echo $product->get_name(); ?>" src="<?php echo zardkooh_get_product_img($product); ?>" width="215" height="215">
		<a href="<?php echo get_permalink($product->get_id()); ?>" class="single-product-box-link"><?php echo _e('View Full Product Details','zardkooh');?></a>
	</div>
	<div class="single-product-box-main">
		<h3><?php echo $product->get_name(); ?></h3>
		<?php if ( $description ) { ?>
			<div class="single-product-box-description"><?php echo wp_trim_words(strip_tags($product->get_description()), 120, '...'); ?></div>
		<?php } ?>
		<?php if ( $attributes && !empty($product->get_attributes()) ) { $product_attributes = $product->get_attributes(); ?>
			<div class="single-product-box-attributes">
				<table class="zardkooh-attributes-table">
					<?php $counter = 0; foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
						<?php if ( $counter < 5 ) { ?>
							<tr class="woocommerce-product-attributes-item woocommerce-product-attributes-item--<?php echo esc_attr( $product_attribute_key ); ?>">
								<th class="zardkooh-attributes-table-name"><?php echo wp_kses_post( wc_attribute_label( $product_attribute->get_name() ) ); ?></th>
								<?php
								$values = array();

								if ( $product_attribute->is_taxonomy() ) {
									$attribute_taxonomy = $product_attribute->get_taxonomy_object();
									$attribute_values   = wc_get_product_terms( $product->get_id(), $product_attribute->get_name(), array( 'fields' => 'all' ) );

									foreach ( $attribute_values as $attribute_value ) {
										$value_name = esc_html( $attribute_value->name );

										if ( $attribute_taxonomy->attribute_public ) {
											$values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $product_attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
										} else {
											$values[] = $value_name;
										}
									}
								} else {
									$values = $product_attribute->get_options();

									foreach ( $values as &$value ) {
										$value = make_clickable( esc_html( $value ) );
									}
								}
								?>
								<td class="zardkooh-attributes-table-value"><?php echo wp_kses_post( apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $product_attribute, $values ) ); ?></td>
							</tr>
						<?php } ?>
					<?php $counter++; endforeach; ?>
				</table>
			</div>
		<?php } ?>
	</div>
</section>