<?php
/**
 * The template for displaying all single posts
 *
 */

get_header();

$section_class = 'col-sm-12';
if ( is_active_sidebar( 'blog-sidebar' ) && isset($zardkooh_options['single_blog_sidebar']) && $zardkooh_options['single_blog_sidebar'] ) {
    $section_class = 'col-sm-9';
}
?>
<div class="container main-warp">
	<?php //zardkooh_breadcrumbs(); ?>
	<div class="row">
		<section class="<?php echo $section_class; ?>">
			<?php while ( have_posts() ) : the_post(); ?>
				<?php 
				$video_url		= get_post_meta($post->ID, 'video_url', true);
				$video_time		= get_post_meta($post->ID, 'video_time', true);
				
				$is_video = false;
				if ( $video_url && !empty($video_url) ) {
					$is_video = true;
				}
				?>
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<div class="single-post-box <?php if ( $is_video ) { echo 'is-video'; } ?>">
						<?php if ( $is_video ) { ?>
							<figure class="post-attachment">
								<?php echo do_shortcode('[video src="'.$video_url.'" poster="'.get_the_post_thumbnail_url().'"]'); ?>
								<figcaption>
									<div><?php the_title(); ?></div>
									<?php if ( $video_time ) { ?>
										<div>
											<span class="video-time"><?php echo $video_time; ?></span>
										</div>
									<?php } ?>
								</figcaption>
							</figure>
						<?php } else { ?>
                            <?php if ( isset($zardkooh_options['single_blog_image']) && $zardkooh_options['single_blog_image'] ) { ?>
                                <figure class="post-attachment">
                                    <?php the_post_thumbnail(); ?>
                                    <figcaption class="hidden"><?php the_title(); ?></figcaption>
                                </figure>
                            <?php } ?>
                        <?php } ?>
						
						<h1 class="entry-title post-title"><?php the_title(); ?></h1>
						<div class="post-meta">
							<div class="post-meta-right">
								<span class="blog-post-breadcrumb"><?php the_category( ', ' ); ?></span>
							</div>
							<div class="post-meta-left">
                                <span class="post-comments"><span class="post-meta-span"><?php echo get_comments_number(). ' ' .__('Comment','zardkooh'); ?></span></span>
                                <span class="post-date"><span class="post-meta-span"><?php the_time('Y/m/d') ?></span></span>
                                <span class="post-author"><span class="post-meta-span"><?php echo get_the_author_meta( 'display_name' ); ?></span></span>
                                <span class="post-views"><span class="post-meta-span"><?php echo zardkooh_get_post_view(). ' ' .__('Views','zardkooh'); ?></span></span>
								<?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating() ) { ?>
									<span class="post-rate">
										<div class="average-stars"><?php echo rmp_get_visual_rating(); ?></div>
										<span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating()); ?></span>/5
									</span>
								<?php } ?>
							</div>
							
						</div>
						
						<div class="post-content">
							<?php the_content() ;?>

							<div class="post-tags">
								<?php the_tags( '# ', ', ' ); ?>
							</div>
						</div>
						
						<?php zardkooh_set_post_view();	?>
					</div>

				</article>
			<?php endwhile; // End of the loop.	?>
        </section>

        <?php if ( is_active_sidebar( 'blog-sidebar' ) && isset($zardkooh_options['single_blog_sidebar']) && $zardkooh_options['single_blog_sidebar'] ) { ?>
            <aside class="col-sm-3 blog-sidebar">
                <?php dynamic_sidebar( 'blog-sidebar' ); ?>
            </aside>
        <?php } ?>

	</div>

    <div class="single-rate-share-box <?php if ( $is_video ) { echo 'is-video'; } ?>">
        <div class="single-share-section">
            <ul class="social-networks">
                <a href="https://telegram.me/share/url?url=<?php echo esc_url(site_url()).'/?p='.get_the_id();?>" target="_blank">
                    <li><i class="social-icon social-telegram"></i><span><?php echo _e('Telegram','zardkooh'); ?><span></li>
                </a>

                <a href="https://plus.google.com/share?url=<?php echo esc_url(site_url()).'/?p='.get_the_id();?>" target="_blank" data-title="<?php echo get_the_title();?>" data-image="<?php echo get_the_post_thumbnail_url();?>" data-url="<?php echo esc_url(site_url()).'/?p='.get_the_id();?>">
                    <li><i class="social-icon social-gmail"></i><span><?php echo _e('Google Plus','zardkooh'); ?><span></li>
                </a>

                <a href="https://twitter.com/home?status=<?php echo esc_url(site_url()).'/?p='.get_the_id();?>" target="_blank" data-title="<?php echo get_the_title();?>" data-image="<?php echo get_the_post_thumbnail_url();?>" data-url="<?php echo esc_url(site_url()).'/?p='.get_the_id();?>">
                    <li><i class="social-icon social-twitter"></i><span><?php echo _e('Twitter','zardkooh'); ?><span></li>
                </a>

                <a href="https://www.facebook.com/sharer.php?u=<?php echo esc_url(site_url()).'/?p='.get_the_id();?>" target="_blank" data-title="<?php echo get_the_title();?>" data-image="<?php echo get_the_post_thumbnail_url();?>" data-url="<?php echo esc_url(site_url()).'/?p='.get_the_id();?>">
                    <li><i class="social-icon social-facebook"></i><span><?php echo _e('Facebook','zardkooh'); ?><span></li>
                </a>
            </ul>
        </div>
        <?php if ( function_exists('rmp_get_visual_rating') ) { ?>
            <div class="single-rate-section">
                <?php echo do_shortcode('[ratemypost]'); ?>
            </div>
        <?php } ?>
    </div>

</div>

<div class="container single-comment-section">
	<div class="row">
		<?php
		// If comments are open or we have at least one comment, load up the comment template.
		if ( comments_open() || get_comments_number() ) :
			comments_template();
		endif;
		?>
	</div>
</div>

<?php get_footer();
