<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

global $wp_query, $zardkooh_options;

$total_products = $wp_query->found_posts; 

$current_sort	= ( isset ($_GET["orderby"]) ) ? $_GET["orderby"] : false;
$sort_label		= zardkooh_get_sorting_option_name($current_sort);
?>

<div class="container">
	<div class="shop-page-row">
		<?php if ( zardkooh_is_mobile() ) { ?>
			<div class="shop-filters">
				<a class="btn-filter btn-filter-advanced" href="#" data-remodal-target="advanced-filter"><?php echo _e('Advanced Search','zardkooh'); ?></a>
				<a class="btn-filter btn-filter-sort" href="#" data-remodal-target="sort-filter"><?php echo $sort_label; ?></a>
			</div>
			<div class="remodal-wrapper">
				<div class="remodal remodal-filter" data-remodal-id="advanced-filter" data-remodal-options="hashTracking: false" role="dialog" aria-labelledby="modal1Title" aria-describedby="modal1Desc" tabindex="-1" data-remodal-options="hashTracking: false">
					<button data-remodal-action="close" class="remodal-close" aria-label="Close"></button>
					<div class="remodal-filter-header"><?php echo _e('Advanced Search','zardkooh'); ?></div>
					<div class="remodal-filter-content">
						<?php dynamic_sidebar( 'shop-sidebar' ); ?>
					</div>
				</div>
			</div>
		<?php } else { ?>
            <div class="shop-filters-panel">
                <div class="filter-panel-col">
                    <?php dynamic_sidebar( 'shop-sidebar' ); ?>
                </div>
            </div>
		<?php } ?>
		
		<div class="shop-main-panel">
			<?php
			/**
			 * Hook: woocommerce_before_main_content.
			 *
			 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
			 * @hooked woocommerce_breadcrumb - 20
			 * @hooked WC_Structured_Data::generate_website_data() - 30
			 */
			do_action( 'woocommerce_before_main_content' );
			?>
			
			<div class="shop-page-breadcrumb-row">
				<?php woocommerce_breadcrumb(); ?>
				<?php if ( isset($zardkooh_options['display_options']) && $zardkooh_options['display_options'] ) { ?>
					<ul class="shop-page-header-type">
						<li><?php echo _e( 'Display As: ', 'zardkooh' ); ?></li>
						<?php
						$grid = 'is-active';
						$list = '';
						if ( isset($zardkooh_options['default_display']) && $zardkooh_options['default_display'] == 'list' ) {
							$grid = '';
							$list = 'is-active';
						}
						?>
						<li data-type="list" class="header-type-btn <?php echo $list; ?>"><?php echo _e( 'As Row', 'zardkooh' ); ?></li>
						<li data-type="grid" class="header-type-btn <?php echo $grid; ?>"><?php echo _e( 'As Column', 'zardkooh' ); ?></li>
					</ul>
				<?php } ?>
			</div>
			<?php
			$view_type = '';
			if ( isset($zardkooh_options['default_display']) && $zardkooh_options['default_display'] == 'list' ) {
				$view_type = 'is-list';
			}
			?>
			<div class="shop-page-products <?php echo $view_type; ?>">
				<?php
				if ( woocommerce_product_loop() ) {

					/**
					 * Hook: woocommerce_before_shop_loop.
					 *
					 * @hooked woocommerce_output_all_notices - 10
					 * @hooked woocommerce_result_count - 20
					 * @hooked woocommerce_catalog_ordering - 30
					 */
					do_action( 'woocommerce_before_shop_loop' );

					woocommerce_product_loop_start();

					if ( wc_get_loop_prop( 'total' ) ) {
						while ( have_posts() ) {
							the_post();

							/**
							 * Hook: woocommerce_shop_loop.
							 *
							 * @hooked WC_Structured_Data::generate_product_data() - 10
							 */
							do_action( 'woocommerce_shop_loop' );

							wc_get_template_part( 'content', 'product' );
						}
					}

					woocommerce_product_loop_end();

					/**
					 * Hook: woocommerce_after_shop_loop.
					 *
					 * @hooked woocommerce_pagination - 10
					 */
					do_action( 'woocommerce_after_shop_loop' );
				} else {
					/**
					 * Hook: woocommerce_no_products_found.
					 *
					 * @hooked wc_no_products_found - 10
					 */
					do_action( 'woocommerce_no_products_found' );
				}

				/**
				 * Hook: woocommerce_after_main_content.
				 *
				 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
				 */
				do_action( 'woocommerce_after_main_content' );
				?>
			</div>
		</div>
	</div>
</div>
<?php
if ( is_product_taxonomy() && 0 === absint( get_query_var( 'paged' ) ) ) {
	$term = get_queried_object();
	if ( $term && !empty( $term->description ) ) {
	?>
	<div class="container">
		<div class="product-cat-description">
			<div class="description-text">
				<?php
				/**
				 * woocommerce_archive_description hook.
				 *
				 * @hooked woocommerce_taxonomy_archive_description - 10
				 * @hooked woocommerce_product_archive_description - 10
				 */
				do_action( 'woocommerce_archive_description' );
				?>
			</div>
		</div>
	</div>
	<?php 
	}
}
/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
do_action( 'woocommerce_sidebar' );

get_footer( 'shop' );
