<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */

global $product, $zardkooh_options;

do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>
	<?php if ( !zardkooh_is_mobile() ) { ?>	
			<div class="product-page">
				<div class="single-product-right-box">
                    <div class="single-product-right-box-content">
                        <div class="summary entry-summary white-box">
                            <?php do_action( 'zardkooh_single_product_side_header_top' ); ?>

                            <div class="product-page-header">
                                <h1>
                                    <span><?php echo get_post_meta ($product->get_id(), 'product_english_name', true); ?></span>
                                    <?php the_title(); ?>
                                </h1>

                                <?php echo zardkooh_single_product_tags(); ?>
                            </div>

                            <div class="product-page-side-cart">
                                <?php
                                    /**
                                     * Hook: woocommerce_single_product_summary.
                                     *
                                     * @hooked woocommerce_template_single_title - 5
                                     * @hooked woocommerce_template_single_rating - 10
                                     * @hooked woocommerce_template_single_price - 10
                                     * @hooked woocommerce_template_single_excerpt - 20
                                     * @hooked woocommerce_template_single_add_to_cart - 30
                                     * @hooked woocommerce_template_single_meta - 40
                                     * @hooked woocommerce_template_single_sharing - 50
                                     * @hooked WC_Structured_Data::generate_product_data() - 60
                                     */
                                    do_action( 'woocommerce_single_product_summary' );
                                ?>
                            </div>
                        </div>
                        <?php
                            /**
                             * Hook: woocommerce_single_product_summary.
                             *
                             * @hooked zardkooh_single_inventory - 5
                             * @hooked zardkooh_single_experts - 10
                             */
                            do_action( 'zardkooh_single_product_side' );
                        ?>
                    </div>
				</div>
				<div class="single-product-center-box">
					<div class="single-product-image white-box">
					<?php
						do_action( 'woocommerce_before_single_product_image' );
						/**
						 * Hook: woocommerce_before_single_product_summary.
						 *
						 * @hooked woocommerce_show_product_sale_flash - 10
						 * @hooked woocommerce_show_product_images - 20
						 */
						do_action( 'woocommerce_before_single_product_summary' );
					?>
					</div>
					
					<?php
						/**
						 * Hook: woocommerce_after_single_product_summary.
						 *
						 * @hooked woocommerce_output_product_data_tabs - 10
						 * @hooked woocommerce_upsell_display - 15
						 * @hooked woocommerce_output_related_products - 20
						 */
						do_action( 'woocommerce_after_single_product_summary' );
					?>
				</div>
				
				<?php do_action( 'zardkooh_single_product_sticky_menu' ); ?>

			</div>
		
	<?php } else { ?>

			<div class="product-page">
				<div class="single-product-right-box">
					
					<div class="summary entry-summary white-box">
						<?php do_action( 'zardkooh_single_product_side_header_top' ); ?>
					
						<div class="product-page-header">
							<h1>
								<span><?php echo get_post_meta ($product->get_id(), 'product_english_name', true); ?></span>
								<?php the_title(); ?>
							</h1>
							
							<?php
								do_action( 'woocommerce_before_single_product_image' );
								/**
								 * Hook: woocommerce_before_single_product_summary.
								 *
								 * @hooked woocommerce_show_product_sale_flash - 10
								 * @hooked woocommerce_show_product_images - 20
								 */
								do_action( 'woocommerce_before_single_product_summary' );
							?>
						
							<?php echo zardkooh_single_product_tags(); ?>
						</div>
						
						<div class="product-page-side-cart">
							<?php
								/**
								 * Hook: woocommerce_single_product_summary.
								 *
								 * @hooked woocommerce_template_single_title - 5
								 * @hooked woocommerce_template_single_rating - 10
								 * @hooked woocommerce_template_single_price - 10
								 * @hooked woocommerce_template_single_excerpt - 20
								 * @hooked woocommerce_template_single_add_to_cart - 30
								 * @hooked woocommerce_template_single_meta - 40
								 * @hooked woocommerce_template_single_sharing - 50
								 * @hooked WC_Structured_Data::generate_product_data() - 60
								 */
								do_action( 'woocommerce_single_product_summary' );
							?>
						</div>
					</div>
					
					<?php
						/**
						 * Hook: woocommerce_single_product_summary.
						 *
						 * @hooked zardkooh_single_inventory - 5
						 * @hooked zardkooh_single_experts - 10
						 */
						do_action( 'zardkooh_single_product_side' );
					?>
				</div>
				<div class="single-product-center-box">
					<?php
						/**
						 * Hook: woocommerce_after_single_product_summary.
						 *
						 * @hooked woocommerce_output_product_data_tabs - 10
						 * @hooked woocommerce_upsell_display - 15
						 * @hooked woocommerce_output_related_products - 20
						 */
						do_action( 'woocommerce_after_single_product_summary' );
					?>
				</div>
				
			</div>
	<?php } ?>
	
</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
