<?php
/**
 * Lost password confirmation text.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/lost-password-confirmation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $zardkooh_options;

if ( isset( $zardkooh_options['logo'] ) && strlen( $zardkooh_options['logo']['url'] ) > 0 ) {
	$logo_href = $zardkooh_options['logo']['url'];
} else {
	$logo_href = get_template_directory_uri().'/assets/images/logo.svg';
}
wc_print_notice( esc_html__( 'Password reset email has been sent.', 'woocommerce' ) );
?>
<div class="account-page-layout">
	<a href="<?php echo home_url('/');?>" class="account-page-logo"><img src="<?php echo $logo_href; ?>" alt="<?php echo get_bloginfo();?>"></a>
	<div class="account-box-main">
		<div class="account-box-top">
			<h3><?php esc_attr_e( 'Reset password', 'woocommerce' ); ?></h3>
			<div class="account-box-content">
			
				<?php do_action( 'woocommerce_before_lost_password_confirmation_message' ); ?>
				
				<p class="reminde-text"><?php echo esc_html( apply_filters( 'woocommerce_lost_password_confirmation_message', esc_html__( 'A password reset email has been sent to the email address on file for your account, but may take several minutes to show up in your inbox. Please wait at least 10 minutes before attempting another reset.', 'woocommerce' ) ) ); ?></p>
				
				<?php do_action( 'woocommerce_after_lost_password_confirmation_message' ); ?>
				
			</div>
		</div>
		<div class="account-box-footer">
			<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="btn-link-border"><?php echo _e ('Login To Site','zardkooh');?></a>
		</div>
	</div>
	<a href="<?php echo home_url('/');?>" class="account-page-return"><?php echo _e ('Return To Homepage','zardkooh');?></a>
</div>