<?php
/**
 * View Order
 *
 * Shows the details of a particular order on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/view-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="view-order-title">
	<span class="view-order-tag order-number-tag"><?php _e ( 'Order Number: ','zardkooh' ); ?><?php echo $order->get_order_number(); ?></span>
	<span class="view-order-tag order-date-tag"><?php _e ( 'Submitted on: ','zardkooh' ); ?><?php echo wc_format_datetime( $order->get_date_created() ); ?></span>
	<span class="view-order-tag order-status-tag"><?php _e ( 'Status: ','zardkooh' ); ?><?php echo wc_get_order_status_name( $order->get_status() ); ?></span>
</div>

<?php if ( $notes = $order->get_customer_order_notes() ) : ?>
	<div class="account-headline">
		<span><?php _e( 'Order updates', 'woocommerce' ); ?></span>
	</div>
	<ol class="woocommerce-OrderUpdates commentlist notes">
		<?php foreach ( $notes as $note ) : ?>
		<li class="woocommerce-OrderUpdate comment note">
			<div class="woocommerce-OrderUpdate-inner comment_container">
				<div class="woocommerce-OrderUpdate-text comment-text">
					<p class="woocommerce-OrderUpdate-meta meta"><?php echo date_i18n( __( 'l j S F Y, h:ia', 'woocommerce' ), strtotime( $note->comment_date ) ); ?></p>
					<div class="woocommerce-OrderUpdate-description description">
						<?php echo wpautop( wptexturize( $note->comment_content ) ); ?>
					</div>
	  				<div class="clear"></div>
	  			</div>
				<div class="clear"></div>
			</div>
		</li>
		<?php endforeach; ?>
	</ol>
<?php endif; ?>

<div class="account-headline">
	<span><?php _e ( 'User Information','zardkooh' ); ?></span>
</div>
<div class="account-user-info">
	<div class="account-user-info-row">
		<div class="account-user-info-col">
			<p><span><?php _e ( 'Full Name: ','zardkooh' ); ?></span><?php echo $order->get_billing_first_name().' '.$order->get_billing_last_name().' ( '.$order->get_billing_company().' )';?></p>
		</div>
		<div class="account-user-info-col">
			<p><span><?php _e ( 'Email: ','zardkooh' ); ?></span><?php echo $order->get_billing_email();?></p>
		</div>
	</div>
	<div class="account-user-info-row">
		<div class="account-user-info-col">
			<p><span><?php _e ( 'Mobile: ','zardkooh' ); ?></span><?php echo get_user_meta($order->get_customer_id(),'billing_mobile',true); ?></p>
		</div>
		<div class="account-user-info-col">
			<p><span><?php _e ( 'Phone Number: ','zardkooh' ); ?></span><?php echo $order->get_billing_phone();?></p>
		</div>
	</div>
	<div class="account-user-info-row">
		<div class="account-user-info-col">
			<p><span><?php _e ( 'Address: ','zardkooh' ); ?></span>
				<?php 
				$country	= $order->get_billing_country();
				$state		= $order->get_billing_state();
				$allstates	= WC()->countries->get_states( $country );
				if ( !empty( $allstates ) && is_array( $allstates ) && isset( $allstates[$state] ) ) {
					$state = $allstates[$state];
				}
				$city		= $order->get_billing_city();
				$address	= $order->get_billing_address_1();
				$postalcode	= $order->get_billing_postcode();
				?>
				<?php _e ( 'State ','zardkooh' ); ?><?php echo $state;?><?php _e ( ', City ','zardkooh' ); ?><?php echo $city; ?>، <?php echo $address; ?> ( <?php echo $postalcode; ?> )
			</p>
		</div>
		<div class="account-user-info-col">
			<p><span><?php _e ( 'Total Price: ','zardkooh' ); ?></span><?php echo $order->get_formatted_order_total( );?></p>
		</div>
	</div>
</div>

<?php do_action( 'woocommerce_view_order', $order_id ); ?>
