<?php
/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.5.1
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;

$attachment_ids = $product->get_gallery_image_ids();

$count = 1;
$more_count = 4;
if ( zardkooh_product_has_video($product) ) {
    $count = 2;
    $more_count = 5;
}

if ( $attachment_ids && $product->get_image_id() ) {	
	foreach ( $attachment_ids as $attachment_id ) {
		if ( $count < $more_count+1 ) {
			if ( $count == $more_count ) {
				echo '<li class="woocommerce-product-thumb"><button class="open-gallery has-more-images"></button></li>';
			} else {
				echo apply_filters( 'woocommerce_single_product_thumbnails_html', wc_get_gallery_image_html( $attachment_id ), $attachment_id, $count ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped
			}			
		}
		$count++;
	}
}
