<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $related_products ) : ?>

	<?php if ( zardkooh_is_mobile() ) { ?>
		
		<section class="products-swiper in-single-page related-section" id="related-section">
			<div class="object-headline">
				<span>
				<?php
				$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'woocommerce' ) );

				if ( $heading ) { echo esc_html( $heading ); } ?>
				</span>
			</div>
			<div class="zardkooh-products-row">
				<div class="products-row">
					<?php
					foreach ( $related_products as $related_product ) :
						
						$post_object = get_post( $related_product->get_id() );

						setup_postdata( $GLOBALS['post'] =& $post_object );

						global $product, $zardkooh_options;
						?>
						<div class="products-swiper-p-box">
							<a href="<?php the_permalink(); ?>" class="products-swiper-link">
								<div class="products-swiper-img">
									<img alt="<?php the_title(); ?>" class="swiper-lazy" data-src="<?php echo zardkooh_get_product_img($product); ?>" src="<?php echo zardkooh_get_product_img($product); ?>" width="205" height="205">
								</div>
								<div class="products-swiper-title"><?php echo get_the_title(); ?></div>
								<div class="products-swiper-footer">
									<span class="products-swiper-button"><?php echo _e('View','zardkooh');?></span>
									<div class="products-swiper-price">
										<?php echo $product->get_price_html(); ?>
										<span class="products-swiper-discount"><?php echo zardkooh_get_product_discount_percent($product); ?></span>
									</div>
								</div>
							</a>
						</div>
					<?php endforeach; wp_reset_postdata(); ?>
				</div>
			</div>
		</section>
		
	<?php } else { ?>

		<section class="products-swiper in-single-page related-section" id="related-section">
			<div class="object-headline">
				<span>
				<?php
				$heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'woocommerce' ) );

				if ( $heading ) { echo esc_html( $heading ); } ?>
				</span>
			</div>
			<div class="products-swiper-box">
				<div class="swiper-container swiper-container-products3" <?php language_attributes(); ?>>
					<div class="swiper-wrapper">
						<?php 
						foreach ( $related_products as $related_product ) :
						
							$post_object = get_post( $related_product->get_id() );

							setup_postdata( $GLOBALS['post'] =& $post_object );

							global $product, $zardkooh_options;
							?>
							<div class="swiper-slide">
								<div class="products-swiper-p-box">
									<a href="<?php the_permalink(); ?>" class="products-swiper-link"></a>
									<a class="products-swiper-img" href="<?php the_permalink(); ?>">
										<img alt="<?php the_title(); ?>" class="swiper-lazy" data-src="<?php echo zardkooh_get_product_img($product); ?>" src="<?php echo zardkooh_get_product_img($product); ?>" width="205" height="205">
									</a>
									<div class="products-swiper-title"><?php the_title(); ?></div>
									<div class="products-swiper-footer">
										<a href="<?php the_permalink(); ?>" class="products-swiper-button"></a>
										<div class="products-swiper-price">
											<?php echo $product->get_price_html(); ?>
											<?php if ( zardkooh_get_product_discount_percent($product) ) { ?>
												<span class="products-swiper-discount"><?php echo zardkooh_get_product_discount_percent($product); ?></span>
											<?php } ?>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; wp_reset_postdata(); ?>
					</div>
				</div>
				<div class="swiper-pagination"></div>
			</div>
		</section>
		
	<?php } ?>

<?php endif;

//}

wp_reset_postdata();
