/* global wcqrc_product */

jQuery(document).ready(function ($) {
  function toDataURL(src, callback, outputFormat) {
    var img = new Image();
    img.crossOrigin = "Anonymous";
    img.onload = function () {
      var canvas = document.createElement("CANVAS");
      var ctx = canvas.getContext("2d");
      var dataURL;
      canvas.height = this.height;
      canvas.width = this.width;
      ctx.drawImage(this, 0, 0);
      dataURL = canvas.toDataURL(outputFormat);
      callback(dataURL);
    };
    img.src = src;
    if (img.complete || img.complete === undefined) {
      img.src =
        "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==";
      img.src = src;
    }
  }

  $(document).on("click", ".print-qr", function (event) {
    console.log("new link clicked!");
    var img_url = jQuery(".product-qr-code-img").attr("src");
    var product_id = $(this).data("product_id");
    var post_title = jQuery("#original_post_title").val();

    toDataURL(img_url, function (dataUrl) {
      // console.log('RESULT:', dataUrl)
      var doc = new jsPDF();
      doc.setFontSize(25);
      // doc.text(35, 25, post_title);
      doc.addImage(dataUrl, "JPEG", 15, 40, 180, 180);
      doc.save(product_id + ".pdf");
    });
  });

  $(document).on("click", ".wcqrc-refresh", function (event) {
    //console.log("new link clicked!");
    var product_id = $(this).data("product_id");
    var data = {
      action: "regenerate_qr_code",
      product_id: product_id
    };
    $.post(wcqrc_product.ajax_url, data, function (response) {
      if (response) {
        console.log("QR code deleted");
        $(".product-qr-code-img").hide();
      }
    });
  });

  $(".wcqrc-refresh").on("click", function () {
    console.log("fire");
    var product_id = $(this).data("product_id");
    var data = {
      action: "regenerate_qr_code",
      product_id: product_id
    };
    $.post(wcqrc_product.ajax_url, data, function (response) {
      if (response) {
        console.log("QR code deleted");
        $(".product-qr-code-img").hide();
      }
    });
  });

  // variable product generate
  $(document).on("click", ".generate-btn", function () {
    //  console.log('fire 1');
    var varid = $(this).attr("data-product_id");

    $.ajax({
      url: ajaxurl, // or example_ajax_obj.ajaxurl if using on frontend
      data: {
        action: "variableqrgen",
        varid: varid
      },
      success: function (data) {
        $("#output_" + varid).html(data);
      },
      error: function (errorThrown) {
        console.log(errorThrown);
      }
    });
  });
  // variable product delete

  $(document).on("click", ".delete-btn", function () {
    var varid = $(this).attr("data-product_id");

    $.ajax({
      url: ajaxurl,
      data: {
        action: "variableqrdel",
        varid: varid
      },
      success: function (data) {
        $("#output_" + varid).html(" ");
        $("#output_" + varid).html(data);
      },
      error: function (errorThrown) {
        console.log(errorThrown);
      }
    });
  });

  //simple product qr generate

  $(document).on("click", ".simple-qr-gen", function () {
    var simid = $(this).attr("data-product_id");
    $.ajax({
      url: ajaxurl, // or example_ajax_obj.ajaxurl if using on frontend
      data: {
        action: "simpleqrgen",
        simid: simid
      },
      success: function (data) {
        $("#result_" + simid).html(data);
      },
      error: function (errorThrown) {
        console.log(errorThrown);
      }
    });
  });

  // simple product qr delete
  $(document).on("click", ".simple-qr-del", function () {
    var simid = $(this).attr("data-product_id");
    $.ajax({
      url: ajaxurl,
      data: {
        action: "simpleqrdel",
        simid: simid
      },
      success: function (data) {
        $("#result_" + simid).html(data);

      },
      error: function (errorThrown) {
        console.log(errorThrown);
      }
    });
  });
  // coupon qr delete
  $(document).on("click", ".delete-coupon", function () {
    var couid = $(this).attr("data-product_id");

    $.ajax({
      url: ajaxurl,
      data: {
        action: "delcoupon",
        couid: couid
      },
      success: function (data) {
        $("#coupon_" + couid).html(data);
      },
      error: function (errorThrown) {
        console.log(errorThrown);
      }
    });
  });

  //coupon qr generate
  $(document).on("click", ".generate-coupon", function () {
    //  console.log('fire 1');
    var couid = $(this).attr("data-product_id");

    $.ajax({
      url: ajaxurl, // or example_ajax_obj.ajaxurl if using on frontend
      data: {
        action: "gencoupon",
        couid: couid
      },
      success: function (data) {
        $("#coupon_" + couid).html(data);
      },
      error: function (errorThrown) {
        console.log(errorThrown);
      }
    });
  });
});
